//********************************************************************************
//								     Include
//********************************************************************************
#include "MDSF05_SFR.h"
#include "XSFR_GLOBAL.h"
#include "Allhex.h"

#define BUSY 	0x08
#define START 	0x01

//********************************************************************************
//								   ADC INIT
//********************************************************************************
void Adc_Init (void){
	ADCCONT = ADCCONT_REGS;
	ADCSTR = ADCSTR_REGS | OPA_GAIN_REGS;
	
	IA_AD_OFFSET(512);		//512 = 2.5V; 1023 = 5V
	IB_AD_OFFSET(512);
}
//********************************************************************************
//								  ADC Channel
//********************************************************************************
//#if ((POWER_CONTROL == 1) || (POWER_LIMIT == 1) || (VSP_TRI == 1) || (Vbus_Protect == 1) || (Temperture_Protect == 1))
unsigned int Adc_Channel (unsigned char Channel){
	uint16 Temp;
	ADCCONT = (ADCCONT | Channel);
	ADCSTR = (ADCSTR | START);
	while((ADCSTR & BUSY) == BUSY){}; //Check ADC Busy end
	Temp = ADCD1;
	Temp = Temp << 8;
	Temp |= ADCD2;
	ADCCONT = (ADCCONT & 0xF8);
	return Temp;
}
//#endif
//********************************************************************************
//							  Correction Current
//********************************************************************************
// idata	signed int	ia_values;
// idata	signed int	ib_values;

// void Correction_Current_AD_offset(void){
	// ia_values1 = (dFB_Ia_DRH*256) + dFB_Ia_DRL;
	// ib_values1 = (dFB_Ib_DRH*256) + dFB_Ib_DRL;
// }
